#version 330
#extension GL_EXT_gpu_shader4 : enable
//TransformatorMod01.fsh  by   Logos
//https://www.shadertoy.com/view/WtVSWt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Robert Śmietana (Logos) - 11.03.2020
// Bielsko-Biała, Poland, UE, Earth, Sol, Milky Way, Local Group, Laniakea :)



//--- camera stuff ---//

mat3 setCamera(in vec3 ro, in vec3 ta)
{
	vec3 cw = normalize(ta - ro);
	vec3 cp = vec3(0.0, 1.0, sin(0.59*iTime));
	vec3 cu = normalize(cross(cw, cp));
	vec3 cv = normalize(cross(cu, cw));

    return mat3(cu, cv, cw);
}


//--- scene description ---//

float distanceToScene(vec3 p)
{
	float dp = dot(p, p);
	
    p *= 3.0 / dp;
	p  = sin(3.0*p + iTime*vec3(0.0, -4.0, 0.0));

	float d = min(length(p.xz) - 0.15, length(p*p) - 0.1);

	return 0.6*d * dp*0.111111;
}


//--- cheap normal computing ---//

vec3 computeSurfaceNormal(vec3 p)
{
    float d = distanceToScene(p);
    
    return normalize(vec3(
        distanceToScene(p + vec3(0.001, 0.0, 0.0)) - d,
        distanceToScene(p + vec3(0.0, 0.001, 0.0)) - d,
        distanceToScene(p + vec3(0.0, 0.0, 0.001)) - d));
}


//--- output color ---//
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    
    //--- camera setup ---//
    
    float rtime = 0.35*iTime;
    
    vec2 p   = (-iResolution.xy + 2.0*gl_FragCoord.xy - 1.0) / iResolution.y;
 	vec3 pos = vec3(5.0 + 5.0*cos(rtime), 10.0*cos(1.2*rtime), 6.0 + 5.0*sin(0.78*rtime));
    vec3 tar = vec3(0.0);
    vec3 dir = setCamera(pos, tar) * normalize(vec3(p.xy, 11.6));  
    
    
    //--- distance to nearest object in the scene ---//
    
	float t = 0.0;
	for(int i = 0; i < 210; i++)
    {
		float d = distanceToScene(pos + t*dir);
		if(d < 0.003) break;
        
		t += d;

        
		//--- early skip of background pixels ---//
    
        if (t > 27.0)
        {
            gl_FragColor = vec4(0.0);
            return;
        }
	}
    
    
    //--- output color depends on few things ---//
    
    vec3  sn = computeSurfaceNormal(pos + t*dir);			// surface normal
    float dc = clamp(dot(sn, normalize(pos)), 0.0, 1.0);	// diffuse component
    float sr = pow(dc, 100.0);								// specular reflection
    float od = length(pos + t*dir);							// distance to origin
    
	gl_FragColor     = abs(dir.xzyz);
    gl_FragColor    *= 0.2 + 0.8*dc;
    gl_FragColor.yz *= clamp(od, 0.0, 1.0);
    gl_FragColor    += sr;
    
}